% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Proj.R
\name{Proj}
\alias{Proj}
\title{Performs Mercator or Lambert projection of data.}
\usage{
Proj(a, b = 0, scale = getOption("geopar")$scale,
  b0 = getOption("geopar")$b0, b1 = getOption("geopar")$b1,
  l1 = getOption("geopar")$l1, projection = getOption("geopar")$projection,
  col.names = c("lon", "lat"))
}
\arguments{
\item{a,b}{The input data to be projected, may be given as two vectors or as
list attributes, \$lat and \$lon (\$x and \$y if projection = none).}

\item{scale}{The scale used for the projection, (m, km or miles). Default is
the scale defined in geopar (the scale defined when the plot is
initialized).}

\item{b0}{if projection = mercator b0 is the center of the mercator
projection. If projection = "Lambert" b0 and b1 are lattitudes defining the
Lambert projection. Default are the b0 and b1 defined in geopar.}

\item{b1}{Second defining latitute for Lambert projection}

\item{l1}{The longitude defining the Lambert projection, default is the l1
defined in geopar.}

\item{projection}{The projection of the data, legal projections are
"Mercator", "Lambert" and "none".}

\item{col.names}{This has to be set to the default value of c("lon", "lat"),
otherwise projection will be set to "none".}
}
\value{
The function returns a list containing if projection = "none" x and
y, if projection is "Mercator" or "Lambert" it includes the projection
(\$projection), the scale (\$scale), \$lat and \$lon and \$x and \$y (the
distance in \$scale from point (0,0) in spherical coordinates.
}
\description{
Performs Mercator, Lambert or no projection of data, as a default it will
perform the projection used in current plot.
}
\examples{
# For an example of use for this function see i.e. init() where
  # it is called:
\dontrun{
  xgr <- Proj(lat, lon, scale, b0, b1, l1, projection)
}
}
\seealso{
\code{\link{invProj}}, \code{\link{geopar}}, \code{\link{geoplot}}.
}

