% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.mox.R
\name{summarize.mox}
\alias{summarize.mox}
\title{Summary function for the Pathmox Segmentation Trees: PLS-PM}
\usage{
summarize.mox(x, ...)
}
\arguments{
\item{x}{An object of class \code{"xtree.pls"}.}

\item{\dots}{Further arguments are ignored.}
}
\description{
The function \code{summarize.mox} returns the most important results obtained 
by the function \code{pls.pathmox}. In order, it provides the parameters algorithm (
threshold significance, node size limit", tree depth level, and the method used for the 
split partition), the essential characteristics of the tree (deep and number of terminals 
nodes), the basic characteristics of the nodes and the F-global and the F-coefficient
results. For the test results, the significance level is also indicated.
}
\examples{
 
\dontrun{
 ## example of PLS-PM in bank customer satisfaction
 
data(csibank)

# select manifest variables
data.bank <-csibank[,6:32]

# define inner model matrix
Image 			  = rep(0,6)
Expectation	  = c(1,0,0,0,0,0)
Quality		    = c(0,1,0,0,0,0)
Value			    = c(0,1,1,0,0,0)
Satis			    = c(1,1,1,1,0,0)
Loyalty       = c(1,0,0,0,1,0)
inner.bank = rbind(Image,Expectation, Quality, Value, Satis,Loyalty)
colnames(inner.bank) = rownames(inner.bank)

# blocks of indicators (outer model)
outer.bank  = list(1:6,7:10,11:17,18:21,22:24,25:27)
modes.bank = rep("A", 6)


# re-ordering those segmentation variables with ordinal scale 
seg.bank= csibank[,1:5]

seg.bank$Age = factor(seg.bank$Age, ordered=TRUE)
seg.bank$Education = factor(seg.bank$Education, ordered=TRUE)


# Pathmox Analysis
bank.pathmox=pls.pathmox(data.bank, inner.bank, outer.bank, modes.bank,SVAR=seg.bank,signif=0.05,
                         deep=2,size=0.2,n.node=20)
summarize.mox(bank.pathmox)
 
 }
}
\references{
Lamberti, G. (2021) \emph{Hybrid multigroup partial least squares structural equation modelling: 
an application to bank employee satisfaction and loyalty}. 
Quality and Quantity; doi: 10.1007/s11135-021-01096-9;

Lamberti, G. et al. (2017) \emph{The Pathmox approach for PLS path modeling: 
Discovering which constructs differentiate segments.}. 
Applied Stochastic Models in Business and Industry; doi: 10.1002/asmb.2270;

Lamberti, G. et al. (2016) \emph{The Pathmox approach for PLS path modeling segmentation}. 
Applied Stochastic Models in Business and Industry; doi: 10.1002/asmb.2168;

Lamberti, G. (2015) \emph{Modeling with Heterogeneity.} PhD Dissertation.


\code{\link{pls.pathmox}}
}
\author{
Giuseppe Lamberti
}
