% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/30_fun_invariance_test.R
\name{invariance_test}
\alias{invariance_test}
\title{Invariance Test}
\usage{
invariance_test(x, nodes, inner, outer, mode, scheme, scaled)
}
\arguments{
\item{x}{Matrix or data frame containing the manifest variables.}

\item{nodes}{List of vectors. Each vector contains the position of the
individual that belongs to a specific node.}

\item{inner}{A square (lower triangular) boolean matrix representing 
the inner model (i.e. the path relationships between latent variables).}

\item{outer}{list of vectors with column indices or column names
from \code{Data} indicating the sets of manifest variables forming 
each block (i.e. which manifest variables correspond to each block).}

\item{mode}{character vector indicating the type of measurement for each
block. Possible values are: \code{"A", "B", "newA", "PLScore", "PLScow"}. 
The length of \code{mode} must be equal to the length of \code{outer}.}

\item{scheme}{string indicating the type of inner weighting
scheme. Possible values are \code{"centroid"}, \code{"factorial"}, or
\code{"path"}.}

\item{scaled}{whether manifest variables should be standardized. 
Only used when \code{scaling = NULL}. When (\code{TRUE}, data is 
scaled to standardized values (mean=0 and variance=1).}
}
\value{
An data.farme \code{res}. Basically a list with the
following results:

\item{chisq.statistic}{A Number; X^2 statistic}

\item{p.value}{A Number; p-value}

\item{dfH0}{A Number; degree of freedom null Hypotheis}

\item{dfH1}{A Number; degree of freedom alternative Hypotheis}

\item{avg.weights}{data frame of the common weights if they exist}

\item{test}{data frame with summry information of the invariance test}
}
\description{
The invariance test is a test that allows to verify the existence of
common weights for the different local PLS-PM models identified by one or more 
segmentation variable.
}
\details{
The \code{"x"} refers to a matrix or a data.farme that contains all individuals 
used for the global PLS-PM estimation
The \code{"nodes"} is a list of vectors. Each vector contains the position of the  
individual that belongs to a specific node. The position is idenfied by the number of row.
For example, the row 4 corresponds to the individual 4 
The other parameters are the classical parameter of the fucntion \code{"plspm"}
}
\examples{
 \dontrun{
 ## example of PLS-PM in alumni satisfaction
 
 data(fibtele)

data.fib <-fibtele[,12:35]

 #define inner model matrix
 Image     	= rep(0,5)
 Qual.spec	  = rep(0,5)
 Qual.gen		= rep(0,5)
 Value			  = c(1,1,1,0,0)
 Satis			  = c(1,1,1,1,0)
 inner.fib = rbind(Image,Qual.spec, Qual.gen, Value, Satis)
 colnames(inner.fib) = rownames(inner.fib)

#define blocks of indicators (outer model)
outer.fib = list(1:8,9:11,12:16,17:20,21:24)

#efine de mode
modes.fib  = rep("A", 5)

#apply plspm
pls.fib = plspm(data.fib, inner.fib, outer.fib, modes.fib)

seg.fib = fibtele[,2:11]

seg.fib$Age = factor(seg.fib$Age, ordered=TRUE)
seg.fib$Salary = factor(seg.fib$Salary, 
                       levels=c("<18k","25k","35k","45k",">45k"), ordered=TRUE)
seg.fib$Accgrade = factor(seg.fib$Accgrade, 
                          levels=c("accnote<7","7-8accnote","accnote>8"), ordered=TRUE)
seg.fib$Grade = factor(seg.fib$Grade, 
                       levels=c("<6.5note","6.5-7note","7-7.5note",">7.5note"), ordered=TRUE)

#pathmox Analysis
fib.pathmox=pls.pathmox(pls.fib,seg.fib,signif=0.05,deep=2,size=0.2,n.node=20)

#pelect the terminal nodes
ls(fib.pathmox)

terminal.nodes=fib.pathmox$terminal[-1] 

#Invariance test
inv.test=invariance_test(data.fib,terminal.nodes,inner.fib,
         outer.fib,modes.fib,scheme="centroid",scaled=FALSE)
inv.test
 }

 ## example of PLS-PM in alumni satisfaction
 
 data(fibtele)

data.fib <-fibtele[,12:35]

#define inner model matrix
Image       = rep(0,5)
Qual.spec	 = rep(0,5)
Qual.gen		 = rep(0,5)
Value			 = c(1,1,1,0,0)
Satis		   = c(1,1,1,1,0)
inner.fib = rbind(Image,Qual.spec, Qual.gen, Value, Satis)
colnames(inner.fib) = rownames(inner.fib)

#define blocks of indicators (outer model)
outer.fib = list(1:8,9:11,12:16,17:20,21:24)

#efine de mode
modes.fib  = rep("A", 5)

#apply plspm
pls.fib = plspm(data.fib, inner.fib, outer.fib, modes.fib)

seg.fib = fibtele[,2:11]

seg.fib$Age = factor(seg.fib$Age, ordered=TRUE)
seg.fib$Salary = factor(seg.fib$Salary, 
                       levels=c("<18k","25k","35k","45k",">45k"), ordered=TRUE)
seg.fib$Accgrade = factor(seg.fib$Accgrade, 
                          levels=c("accnote<7","7-8accnote","accnote>8"), ordered=TRUE)
seg.fib$Grade = factor(seg.fib$Grade, 
                       levels=c("<6.5note","6.5-7note","7-7.5note",">7.5note"), ordered=TRUE)

#pathmox Analysis
fib.pathmox=pls.pathmox(pls.fib,seg.fib,signif=0.05,deep=2,size=0.2,n.node=20)
 
terminal.nodes=fib.pathmox$terminal[-1] 

#Invariance test
inv.test=invariance_test(data.fib,terminal.nodes,inner.fib,
         outer.fib,modes.fib,scheme="centroid",scaled=FALSE)




}
\references{
Lamberti, G., Banet, T. (2017) \emph{Invariance Test: Detecting Difference Between Latent Vari
ables Structure in Partial Least Squares Path Modeling.} International Journal of Statistics and Probability, 
6(2); doi: 10.5539/ijsp.v6n2p54

Lamberti, G. (2014) \emph{Modeling with Heterogeneity.} PhD Dissertation.
}
\author{
Giuseppe Lamberti
}
