% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_bim.R
\name{make_bim}
\alias{make_bim}
\title{Create a plink BIM tibble}
\usage{
make_bim(tib, n = NA)
}
\arguments{
\item{tib}{The input tibble (optional).
Missing columns will be autocompleted with reasonable values that are accepted by plink and other external software.}

\item{n}{The desired number of loci (rows).
Required if \code{tib} is missing; otherwise it is ignored.}
}
\value{
The input tibble with autocompleted columns and columns in default order, or the made up tibble if only the number of individuals was provided.
The output begins with the standard columns in standard order: chr, id, posg, pos, ref, alt.
Additional columns in the input tibble are preserved but placed after the standard columns.
}
\description{
This function simplifies the creation of plink BIM-formatted tibbles, which autocompletes missing information if a partial tibble is provided, or generates a completely made up tibble if the number of individuals is provided.
The default values are most useful for simulated genotypes, where IDs can be made up but must be unique, and there are no chromosomes, positions, or particular reference or alternative alleles.
}
\details{
Autocompleted column values:
\describe{
\item{chr:}{ \code{1} (all data is on a single chromosome) }
\item{id:}{ \code{1:n} }
\item{posg:}{ \code{0} (missing) }
\item{pos:}{ \code{1:n} }
\item{ref:}{ \code{1} }
\item{alt:}{ \code{2} }
}
Note that \eqn{n} is either given directly or obtained from the input tibble.
}
\examples{
# create a synthetic tibble for 10 loci
# (most common use case)
bim <- make_bim(n = 10)

# manually create a partial tibble with only chromosomes defined
library(tibble)
bim <- tibble(chr = 0:2)
# autocomplete the rest of the columns
bim <- make_bim(bim)

}
\seealso{
Plink BIM format reference:
\url{https://www.cog-genomics.org/plink/1.9/formats#bim}
}
