% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exactSdMtx.R
\name{exactSdMtx}
\alias{exactSdMtx}
\title{Exact stochastic dominance computation from areas above ECDFs compared to 
common reference minimum (refmin) for order SD1 to SD4}
\usage{
exactSdMtx(mtx, howManySd = 0.1)
}
\arguments{
\item{mtx}{{(n X p) matrix of data. For example, returns on p stocks n months}}

\item{howManySd}{{used to define (x.ref)= lowest return number by going
default=0.1 howManySd =number of maximum standard deviations in the data below 
the all-row all-column minimum return in the data}}
}
\value{
four matrices SD1 to SD4 for four order of stochastic dominance 
over a common x.ref.  The "out" matrix is another output having 4 rows for
SD1 to SD4 and p columns (p=No. of columns in data matrix mtx).
}
\description{
This function inputs 'mtx' (n X p) matrix data (e.g. monthly returns on p stocks)
Its output has four matrices SD1 to SD4 each with dimension (n X p).
}
\examples{
x1=c(2,5,6,9,13,18,21)
x2=c(3,6,9,12,14,19,27) 
st1=exactSdMtx(cbind(x1,x2))


}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
