% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcorMany.R
\name{parcorMany}
\alias{parcorMany}
\title{Report many generalized partial correlation coefficients 
allowing control variables.}
\usage{
parcorMany(mtx, ctrl = 0, dig = 4, idep = 1, verbo = FALSE)
}
\arguments{
\item{mtx}{{Input data matrix.}}

\item{ctrl}{{Input vector or matrix of data for control variable(s), 
default is ctrl=0 when control variables are absent}}

\item{dig}{The number of digits for reporting (=4, default)}

\item{idep}{The column number of the first variable (=1, default)}

\item{verbo}{Make this TRUE for detailed printing of computational steps}
}
\value{
A five column `out' matrix containing partials. The first column
  has the name of the \code{idep} variable. The
   second column has the name of the j variable, while the third column 
   has partial correlation coefficients  r*(i,j | k).
  The 4-th column has  r*(j,i | k) (denoted partji), and the 5-th column has rijMrji,
  that is the difference in absolute values (abs(partij) - abs(partji)).
}
\description{
This function calls \code{parcor_ijk} function which
uses original data to compute
generalized partial correlations between \eqn{X_i} and \eqn{X_j}
where j can be any one of the remaining
variables in the input matrix denoted as \eqn{x_k}. Calculation 
allows for the presence of control variable(s) if any outside
the input matrix.
}
\note{
We want to get all partial
 correlation coefficients.
}
\examples{
set.seed(234)
z=runif(10,2,11)# z is independently created
x=sample(1:10)+z/10  #x is partly indep and partly affected by z
y=1+2*x+3*z+rnorm(10)# y depends on x and z not vice versa
mtx=cbind(x,y,z)
parcorMany(mtx)
 
   
\dontrun{
set.seed(34);x=matrix(sample(1:600)[1:99],ncol=3)
colnames(x)=c('V1', 'v2', 'V3')
parcorMany(x, idep=1)
}

}
\references{
Vinod, H. D. 'Generalized Correlations and Instantaneous
 Causality for Data Pairs Benchmark,' (March 8, 2015)
 \url{http://ssrn.com/abstract=2574891}

Vinod, H. D. 'Matrix Algebra Topics in Statistics and Economics
 Using R', Chapter 4 in Handbook of Statistics: Computational Statistics
 with R, Vol.32, co-editors: M. B. Rao and C.R. Rao. New York:
 North Holland, Elsevier Science Publishers, 2014, pp. 143-176.
}
\seealso{
See Also \code{\link{parcor_ijk}}.
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY.
}
\keyword{biasing}
\keyword{correlations,}
\keyword{factor,}
\keyword{partial}
\keyword{ridge}
