% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVolcano.R
\name{plotVolcano}
\alias{plotVolcano}
\title{Volcano plot for differential expression analysis}
\usage{
plotVolcano(
  deg_df,
  stat_metric = c("p.adjust", "pvalue"),
  stat_cutoff = 0.05,
  logFC_cutoff = 1,
  up_color = "red",
  down_color = "blue",
  show_gene = NULL,
  dot_size = 1.75,
  ...
)
}
\arguments{
\item{deg_df}{DEG dataframe with gene id, logFC and stat(e.g. pvalue/qvalue).}

\item{stat_metric}{Statistic metric from "pvalue" or "p.adjust".}

\item{stat_cutoff}{Statistic cutoff, default is 0.05.}

\item{logFC_cutoff}{Log2 fold change cutoff, default is 1 which is actually 2 fold change.}

\item{up_color}{Color of up-regulated genes, default is "red".}

\item{down_color}{Color of down-regulated genes, default is "blue".}

\item{show_gene}{Select genes to show, default is no genes to show.}

\item{dot_size}{Volcano dot size, default is 1.75.}

\item{...}{other arguments from `plot_theme` function}
}
\value{
A ggplot object
}
\description{
Volcano plot for differential expression analysis
}
\examples{
\dontrun{
library(ggplot2)
data(deg, package = "genekitr")
plotVolcano(deg,'p.adjust',remove_legend = T,dot_size = 3)

# show some genes
plotVolcano(deg,'p.adjust',remove_legend = T,
show_gene = c("CD36", "DUSP6", "NUPR1", "IER3"))
}

}
