% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getArch_ids.R
\name{getArch_ids}
\alias{getArch_ids}
\title{Get the potential architecture identifiers for the conserved domains}
\usage{
getArch_ids(gene_family)
}
\arguments{
\item{gene_family}{A string with the conserved domain(s) defining the gene
family. The domains have to be shown in the same order appearing in
the sequences.}
}
\value{
all the architectures identifiers for each of the conserved domains.
}
\description{
Parses the SPARCLE database (NCBI) and extract the electronic identifiers
for each conserved domain.
}
\examples{
\dontshow{
arf <- c("pfam06507")
getArch_ids(arf)}

\donttest{
arf <- c("pfam02362", "pfam06507", "pfam02309")
getArch_ids(arf)}

}
\author{
Jose V. Die
}
