% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterArch_ids.R
\name{filterArch_ids}
\alias{filterArch_ids}
\title{Filter the protein architectures based on conserved domains}
\usage{
filterArch_ids(archs_ids, filter)
}
\arguments{
\item{archs_ids}{A string with the architecture identifiers that contain,
at least, one of the conserved domains defining the gene family.}

\item{filter}{A string with the domains (and order) that are required
(at least) for the proteins to have.}
}
\value{
the architecture identifiers from all the potential protein architectures
defined by \code{getArch_ids} that contain, at least, the conserved
domains explicitily show by the filter.
}
\description{
Parse the architecture identifiers and extract those that contain, at
least, those selected in the filter.
}
\examples{
\dontrun{
archs_ids <- getArch_ids("pfam02362")
my_filter <- c("B3_DNA", "Auxin_resp")

filterArch_ids(archs_ids, my_filter) 
}
\dontshow{
archs_ids <- c("12034166", "12034151", "11279088")
my_filter <- c("B3_DNA", "Auxin_resp")
filterArch_ids(archs_ids, my_filter) }

}
\seealso{
\code{\link{getArch_ids}}
}
\author{
Jose V. Die
}
