% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenos.R
\name{hapVsPheno}
\alias{hapVsPheno}
\title{hapVsPheno}
\usage{
hapVsPheno(hap,
           pheno,
           phenoName, hapPrefix = "H",
           title = "test1G0387",
           mergeFigs = TRUE,
           minAcc = 5, outlier.rm = TRUE, ...)
}
\arguments{
\item{hap}{object of hapResult class, generate with\code{vcf2hap()} or
\code{seqs2hap()}}

\item{pheno}{object of data.frame class, imported by \code{import_pheno()}}

\item{phenoName}{pheno name for plot, should be one column name of pheno}

\item{hapPrefix}{prefix of hapotypes, default as "H"}

\item{title}{a charater which will used for figure title}

\item{mergeFigs}{bool type, indicate whether merge the heat map and box
plot or not. Default as \code{TRUE}}

\item{minAcc}{If observations number of a Hap less than this number will
not be compared with others or be ploted. Should not less than 3 due to the
t-test will meaninglessly. default as 5}

\item{outlier.rm}{whether remove ouliers, default as TRUE}

\item{...}{options will pass to \code{ggpubr()}}
}
\value{
list. A list contains a character vector with Haps were applied
student test, a mattrix contains p-value of each compare of Haps and a
ggplot2 object named as figs if mergeFigs set as \code{TRUE}, or two ggplot2
objects names as fig_pvalue and fig_Violin
}
\description{
hapVsPheno
}
\examples{

\donttest{
data("geneHapR_test")
# plot the figs directly
hapVsPheno(hap = hapResult,
           pheno = pheno,
           phenoName = "GrainWeight.2021",
           minAcc = 3)

# do not merge the files
results <- hapVsPheno(hap = hapResult,
                      pheno = pheno,
                      phenoName = "GrainWeight.2021",
                      minAcc = 3,
                      mergeFigs = FALSE)
plot(results$fig_pvalue)
plot(results$fig_Violin)
}
}
