% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen3sis_main.R
\name{run_simulation}
\alias{run_simulation}
\title{Run a simulation in gen3sis and return a summary object possibly saving outputs and plots to the output folder}
\usage{
run_simulation(
  config = NA,
  landscape = NA,
  output_directory = NA,
  timestep_restart = NA,
  save_state = NA,
  call_observer = "all",
  enable_gc = FALSE,
  verbose = 1
)
}
\arguments{
\item{config}{configuration file for the simulation or configuration object derived from a config file}

\item{landscape}{directory where the all_geo_hab and distance_matrices reside}

\item{output_directory}{directory for the simulation output}

\item{timestep_restart}{set the start time time-step. 
If timestep_restart=NA (default), start at the oldest available landscape. 
If timestep_restart="ti", start from the last available time-step. 
If a number "x", start at time-step x (e.g. timestep_restartstart=6)}

\item{save_state}{save the internal state of the simulation for restarts.
If save_state=NA (default), do not save any internal state of the simulation.
If save_state="all", save all time-step. 
If save_state="last", saves only last time-step.
If a vector, saves the desired time-steps (e.g. save_state=c(1,3,5))}

\item{call_observer}{call observer functions.
If call_observer="all" (default), call all time-steps.
If call_observer=NA, calls the start and end times.
If a number "X", call call_observer at x time-steps equally spaced between start and end steps. 
For example, on a simulation with start time of 1 and end time of 20, call_observer=1 calls the observer function at time-steps 1, 11 and 20.}

\item{enable_gc}{enable gc in case of memory shortages}

\item{verbose}{integer value (i.e. 0, 1 ,2 or 3). 
If verbose=0, no printed statement.
If verbose=1 (default), print time-step progress.
If verbose=2, enable additional progress outputs regarding current time-step.
If verbose=3, enable additional information from within modules}
}
\value{
a summary object containing a minimal summary on simulation and dynamics progress (alive, speciations, extinctions) as well as useful simulation data
}
\description{
Run a simulation in gen3sis and return a summary object possibly saving outputs and plots to the output folder
}
\details{
This function runs a simulation with defined landscape and config objects. 
Possibly plot and save specified outputs as defined in the end_of_timestep_observer function inside the config object
}
\examples{
\donttest{
# get path or correct input objects
datapath <- system.file(file.path("extdata", "CaseStudy1"), package="gen3sis")

# run simulation and store summary obejct to sim
sim <- run_simulation(config = file.path(datapath,"config/config_fast.R"), 
                landscape = file.path(datapath,"landscape"),
                output_directory = tempdir())

# plot summary object
plot_summary(sim)
}
}
\seealso{
\code{\link{plot_summary}}   \code{\link{create_input_config}}   \code{\link{create_input_landscape}}
}
