% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_image.R
\name{gemini_image}
\alias{gemini_image}
\title{Generate text from text and image with Gemini}
\usage{
gemini_image(
  image = NULL,
  prompt = "Explain this image",
  model = "1.5-flash",
  temperature = 0.5,
  maxOutputTokens = 1024,
  type = "png"
)
}
\arguments{
\item{image}{The image to generate text}

\item{prompt}{The prompt to generate text, Default is "Explain this image"}

\item{model}{The model to use. Options are '1.5-flash', '1.5-pro' and '2.0-flash-exp'. Default is '1.5-flash'
see https://ai.google.dev/gemini-api/docs/models/gemini}

\item{temperature}{The temperature to use. Default is 0.5 value should be between 0 and 2
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}

\item{maxOutputTokens}{The maximum number of tokens to generate.
Default is 1024 and 100 tokens correspond to roughly 60-80 words.}

\item{type}{The type of image. Options are 'png', 'jpeg', 'webp', 'heic', 'heif'. Default is 'png'}
}
\value{
Generated text
}
\description{
Generate text from text and image with Gemini
}
\examples{
\dontrun{
library(gemini.R)
setAPI("YOUR_API_KEY")
gemini_image(image = system.file("docs/reference/figures/image.png", package = "gemini.R"))
}

}
\seealso{
https://ai.google.dev/docs/gemini_api_overview#text_image_input
}
