% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateData.R
\name{generateData}
\alias{generateData}
\title{Generate Data for Simulation}
\usage{
generateData(
  nsub,
  nobs,
  p,
  beta0,
  rho,
  correlation = "AR1",
  dis = "normal",
  ka = 0,
  SNPs = NULL
)
}
\arguments{
\item{nsub}{Integer, the number of subjects.}

\item{nobs}{Integer or numeric vector, the number of observations per subject.}

\item{p}{Integer, the number of predictors.}

\item{beta0}{Numeric vector, initial coefficients for the first few predictors.}

\item{rho}{Numeric, the correlation coefficient used in generating correlated errors.}

\item{correlation}{Character, the correlation of correlation structure (default is autoregressive).}

\item{dis}{Character, the distribution of errors ("normal" or "t").}

\item{ka}{1 for heterogeneous errors and 0 for homogeneous errors.}

\item{SNPs}{User can provide simulated or real SNPs for genetic data simulation.}
}
\value{
A list containing two elements: `X`, the matrix of predictors, and `y`, the response vector.
}
\description{
This function generates simulated data including the predictor matrix `X` and the response vector `y`,
based on the specified parameters. The function allows for the simulation of data under different settings
of correlation, distribution, and the number of observations and subjects.
}
\examples{
sim_data <- generateData(nsub = 100, nobs = rep(10, 100),  p = 200,
                         beta0 = c(rep(1,7),rep(0,193)), rho = 0.6, correlation = "AR1",
                          dis = "normal", ka = 1)
}
