% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simbinCLF.R
\name{simbinCLF}
\alias{simbinCLF}
\title{Generating Correlated Binary Data using the Conditional Linear Family Method.}
\usage{
simbinCLF(mu, Sigma, n = 1)
}
\arguments{
\item{mu}{a mean vector when \code{n = 1} or is \code{NULL}, otherwise a list of mean vectors for the \code{n} clusters}

\item{Sigma}{a correlation matrix when \code{n = 1} or is \code{NULL}, otherwise a list of correlation matrices for the \code{n} clusters}

\item{n}{number of clusters. The default is \code{1}}
}
\value{
\code{y} a vector of simulated binary outcomes for \code{n} clusters.
}
\description{
simbinCLF generates correlated binary data using the conditional linear family method (Qaqish, 2003).
It simulates a vector of binary outcomes according the specified marginal mean vector and correlation structure.
Natural constraints and compatibility between the marginal mean and correlation matrix are checked.
}
\examples{

#####################################################################
# Simulate 2 clusters, 3 periods and cluster-period size of 5 #######
#####################################################################

t = 3; n = 2; m = 5

# means of cluster 1
u_c1 = c(0.4, 0.3, 0.2)
u1 <- rep(u_c1, c(rep(m, t)))
# means of cluster 2
u_c2 = c(0.35, 0.25, 0.2)
u2 <- rep(u_c2, c(rep(m, t)))

# List of mean vectors
mu = list()
mu[[1]] = u1; mu[[2]] = u2;

# List of correlation matrices

## correlation parameters
alpha0 = 0.03; alpha1 = 0.015; rho = 0.8

## (1) exchangeable
Sigma = list()
Sigma[[1]] = diag(m * t) * ( 1 - alpha1) + matrix(alpha1, m * t,  m * t )
Sigma[[2]] = diag(m * t) * ( 1 - alpha1) + matrix(alpha1, m * t,  m * t )

y_exc = simbinCLF(mu = mu, Sigma = Sigma, n = n)

## (2) nested exchangeable
Sigma = list()
cor_matrix = matrix(alpha1, m * t,  m * t)
loc1 = 0; loc2 = 0
for(t in 1:t){loc1 = loc2 + 1; loc2 = loc1 + m - 1
 for(i in loc1:loc2){for(j in loc1:loc2){
        if(i != j){cor_matrix[i, j] = alpha0}else{cor_matrix[i, j] = 1}}}}

Sigma[[1]] = cor_matrix; Sigma[[2]] = cor_matrix

y_nex = simbinCLF(mu = mu, Sigma = Sigma, n = n)

## (3) exponential decay

Sigma = list()

### function to find the period of the ith index
region_ij<-function(points, i){diff = i - points
    for(h in 1:(length(diff) - 1)){if(diff[h] > 0 & diff[h + 1] <= 0){find <- h}}
 return(find)}

cor_matrix = matrix(0,  m * t,  m * t)
useage_m = cumsum(m * t); useage_m = c(0, useage_m)

for(i in 1:(m * t)){i_reg = region_ij(useage_m, i)
     for(j in 1:(m * t)){j_reg = region_ij(useage_m, j)
         if(i_reg == j_reg & i != j){
             cor_matrix[i, j] = alpha0}else if(i == j){cor_matrix[i, j] = 1
}else if(i_reg != j_reg){cor_matrix[i,j] = alpha0 * (rho^(abs(i_reg - j_reg)))}}}

 Sigma[[1]] = cor_matrix; Sigma[[2]] = cor_matrix

 y_ed = simbinCLF(mu = mu, Sigma = Sigma, n = n)




}
\references{
Qaqish, B. F. (2003). A family of multivariate binary distributions for simulating correlated binary variables with
specified marginal means and correlations. Biometrika, 90(2), 455-463.

Preisser, J. S., Qaqish, B. F. (2014). A comparison of methods for simulating correlated binary variables with specified marginal means
and correlations. Journal of Statistical Computation and Simulation, 84(11), 2441-2452.
}
\author{
Hengshi Yu <hengshi@umich.edu>, Fan Li <fan.f.li@yale.edu>, Paul Rathouz <paul.rathouz@austin.utexas.edu>, Elizabeth L. Turner <liz.turner@duke.edu>, John Preisser <jpreisse@bios.unc.edu>
}
\keyword{cluster-randomized-trials}
\keyword{conditional-linear-family}
\keyword{correlated-binary-data}
