% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{fittedcurve}
\alias{fittedcurve}
\title{Plot Fitted Curves for One or More geerMod Objects}
\usage{
fittedcurve(object, text = "fitted curve", ..., include.CI = FALSE)
}
\arguments{
\item{object}{a fitted joint GEE-MCD/WGEE-MCD model of class "geerMod", i.e.,
typically the result of geer().}

\item{text}{some corresponding descriptions for the objects.}

\item{...}{additional pairs of 'object' and 'text'}

\item{include.CI}{whether or not 95% confidence interval of the fitted values
for the first object should be plotted.}
}
\description{
Plot fitted curves and corresponding 95\% confidence interval
for one or more geerMod objects
}
\examples{
fitgee.ar1 <- geer(cd4|id|time ~ 1|1, data = aids, triple =
  c(6,3,3), method = 'gee-mcd', corr.struct = 'ar1', rho = 0.5)
fittedcurve(fitgee.ar1, text = "GEE-MCD fitted curve", include.CI = TRUE)

}
