/*  vim:expandtab:shiftwidth=2:tabstop=2:smarttab:
 * 
 *  Gearmand client and server library.
 *
 *  Copyright (C) 2011 Data Differential, http://datadifferential.com/
 *  Copyright (C) 2008 Brian Aker, Eric Day
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are
 *  met:
 *
 *      * Redistributions of source code must retain the above copyright
 *  notice, this list of conditions and the following disclaimer.
 *
 *      * Redistributions in binary form must reproduce the above
 *  copyright notice, this list of conditions and the following disclaimer
 *  in the documentation and/or other materials provided with the
 *  distribution.
 *
 *      * The names of its contributors may not be used to endorse or
 *  promote products derived from this software without specific prior
 *  written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


#pragma once

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>

#ifdef NI_MAXHOST
#define GEARMAN_NI_MAXHOST NI_MAXHOST
#else
#define GEARMAN_NI_MAXHOST 1025
#endif

#ifdef NI_MAXSERV
#define GEARMAN_NI_MAXSERV NI_MAXSERV
#else
#define GEARMAN_NI_MAXSERV 32
#endif

/*
  Do not define these enum in your application. There are left publically due to one client.
*/

enum gearman_con_recv_t {
  GEARMAN_CON_RECV_UNIVERSAL_NONE,
  GEARMAN_CON_RECV_UNIVERSAL_READ,
  GEARMAN_CON_RECV_STATE_READ_DATA
};

enum gearman_con_send_t {
  GEARMAN_CON_SEND_STATE_NONE,
  GEARMAN_CON_SEND_UNIVERSAL_PRE_FLUSH,
  GEARMAN_CON_SEND_UNIVERSAL_FORCE_FLUSH,
  GEARMAN_CON_SEND_UNIVERSAL_FLUSH,
  GEARMAN_CON_SEND_UNIVERSAL_FLUSH_DATA
};

enum gearman_con_universal_t {
  GEARMAN_CON_UNIVERSAL_ADDRINFO,
  GEARMAN_CON_UNIVERSAL_CONNECT,
  GEARMAN_CON_UNIVERSAL_CONNECTING,
  GEARMAN_CON_UNIVERSAL_CONNECTED
};
