% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.R
\name{fitted.geolm}
\alias{fitted.geolm}
\title{Extract fitted values from a \code{geolm} object}
\usage{
\method{fitted}{geolm}(object, x, ...)
}
\arguments{
\item{object}{An object produced by the
\code{\link[gear]{geolm}} function.}

\item{x}{A \eqn{m \times p} matrix of covariates for the
locations where fitted values are desired. If 
\code{NULL}, \code{object$x} is used.}

\item{...}{Not currently implemented.}
}
\value{
The vector of fitted values.
}
\description{
Extract the fitted values, i.e., the estimated mean
values, for an \code{object} produced by the
\code{\link[gear]{geolm}} function for a specified set of
covariates, \code{x}. If \code{x} is \code{NULL}, then
then \code{x} is taken from \code{object}.
}
\details{
If the \code{object} has a known mean, i.e.,
\code{object$mu} is not \code{NULL}, then the function
returns the vector \code{rep(object$mu, m)}. If
\code{object} has estimated coefficients, then \code{x
\%*\% object$coeff)} is returned.

If \code{x} is missing, then \code{object$x} is used for
\code{x}. Naturally, \code{ncol(x)} must equal
\code{length(object$coeff)}. If \code{x} is \code{NULL}
and \code{object$mu} is not \code{NULL}, then \code{m} is
taken to be 1.
}
\examples{
data = data.frame(y = rnorm(10), x1 = runif(10),
                 x2 = runif(10))
d = as.matrix(dist(data[,c("x1", "x2")]))
mod = cmod_man(v = exp(-d), evar = 1)
gearmod = geolm(y ~ x1, data = data,
                coordnames = ~ x1 + x2, mod = mod)
# fitted values for original observations
fitted(gearmod)
# fitted values for new observations
fitted(gearmod, x = cbind(1, rnorm(20)))
}
\seealso{
\code{\link[stats]{fitted}}
}
\author{
Joshua French
}
