% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomp_cov.R
\name{decomp_cov}
\alias{decomp_cov}
\alias{decomp.cov}
\title{Decompose covariance matrix}
\usage{
decomp_cov(v, method = "eigen")

decomp.cov(v, method = "eigen")
}
\arguments{
\item{v}{An \eqn{n \times n} covariance matrix.}

\item{method}{The method used to decompose \code{v}.
valid options are \code{"chol"}, \code{"eigen"}, or
\code{"svd"}.}
}
\value{
Returns an \eqn{n \times n} matrix.
}
\description{
\code{decomp_cov} decomposes a covariance matrix
\code{v}.  If \code{A = decomp_cov(v)}, then
\code{tcrossprod(A, A) == v}.
}
\details{
The \code{"chol"} method is the fastest, but must
unstable.  The \code{"eigen"} method is slower, but more
stable.  The \code{"svd"} method is the slowest method,
but should be the most stable.
}
\examples{
# generate data
n = 100
coords = matrix(runif(n*2), nrow = n, ncol = 2)
d = as.matrix(dist(coords))
# create covariance matrix
v = 3 * exp(-d/2) + 0.1 * diag(n)

# decompose v using the three methods
d1 = decomp_cov(v, "chol")
d2 = decomp_cov(v, "eigen")
d3 = decomp_cov(v, "svd")

# verify accuracy of decompositions
range(v - tcrossprod(d1))
range(v - tcrossprod(d2))
range(v - tcrossprod(d3))
}
\author{
Joshua French
}
