% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psd_pseudop.R
\name{psd_pseudop}
\alias{psd_pseudop}
\title{calculate power of spatial determinant(PSD) and the corresponding pseudo-p value}
\usage{
psd_pseudop(y, x, wt, cores = 1, seed = 123456789, permutations = 0)
}
\arguments{
\item{y}{Variable Y, continuous numeric vector.}

\item{x}{Covariable X, \code{factor}, \code{character} or \code{discrete numeric}.}

\item{wt}{The spatial weight matrix.}

\item{cores}{(optional) A positive integer(default is 1). If cores > 1, use parallel computation.}

\item{seed}{(optional) Random seed number, default is \code{123456789}.}

\item{permutations}{(optional) The number of permutations for the PSD computation. Default is \code{0},
which means no pseudo-p values are calculated.}
}
\value{
A tibble of power of spatial determinant and the corresponding pseudo-p value.
}
\description{
Function for calculate power of spatial determinant \eqn{q_s}.
}
\details{
The power of spatial determinant formula is
\eqn{q_s = 1 - \frac{\sum_{h=1}^L N_h \Gamma_h}{N \Gamma}}
}
\examples{
data('sim')
wt = inverse_distance_weight(sim$lo,sim$la,power = 2)
psd_pseudop(sim$y,sdsfun::discretize_vector(sim$xa,5),wt)

}
\references{
Xuezhi Cang & Wei Luo (2018) Spatial association detector (SPADE),International
Journal of Geographical Information Science, 32:10, 2055-2075, DOI:  10.1080/13658816.2018.1476693
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
