% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzyoverlay.R
\name{st_fuzzyoverlay}
\alias{st_fuzzyoverlay}
\title{spatial fuzzy overlay}
\usage{
st_fuzzyoverlay(formula, data, method = "and")
}
\arguments{
\item{formula}{A formula of spatial fuzzy overlay.}

\item{data}{A data.frame or tibble of discretized data.}

\item{method}{(optional) Overlay methods. When \code{method} is \code{and}, use \code{min} to do
fuzzy overlay; and when \code{method} is \code{or},use \code{max} to do fuzzy overlay. Default is \code{and}.}
}
\value{
A spatial fuzzy overlay vector.
}
\description{
Function for spatial fuzzy overlay.
}
\note{
Independent variables in the \code{data} provided to \code{st_fuzzyoverlay()} must be discretized
variables, and dependent variable are continuous variable.
}
\examples{
data('sim')
sim = sim \%>\%
  dplyr::mutate(dplyr::across(4:6,\(.x) st_unidisc(.x,4,"quantile")))
fo1 = st_fuzzyoverlay(y~xa+xb+xc,data = sim, method = 'and')
fo2 = st_fuzzyoverlay(y~xa+xb+xc,data = sim, method = 'or')
fo1
fo2

}
\references{
Yongze Song & Peng Wu (2021) An interactive detector for spatial associations,
International Journal of Geographical Information Science, 35:8, 1676-1701,
DOI:10.1080/13658816.2021.1882680
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
