% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loess.R
\name{loess_optscale}
\alias{loess_optscale}
\title{determine optimal spatial data analysis scale}
\usage{
loess_optscale(qvec, spscalevec, increase_rate = 0.05)
}
\arguments{
\item{qvec}{A numeric vector of q statistics.}

\item{spscalevec}{A numeric vector of spatial scales corresponding to \code{qvec}.}

\item{increase_rate}{(optional) The critical increase rate of the number of discretization.
Default is \verb{5\%}.}
}
\value{
A numeric vector about optimal number of spatial scale and the critical
increase rate of q value.
}
\description{
Function for determining optimal spatial data analysis scale based on locally
estimated scatter plot smoothing (LOESS) model.
}
\examples{
\dontrun{
## The following code takes a long time to run:
library(tidyverse)
fvcpath = "https://github.com/SpatLyu/rdevdata/raw/main/FVC.tif"
fvc = terra::rast(paste0("/vsicurl/",fvcpath))
fvc1000 = fvc \%>\%
  terra::as.data.frame(na.rm = T) \%>\%
  as_tibble()
fvc5000 = fvc \%>\%
  terra::aggregate(fact = 5) \%>\%
  terra::as.data.frame(na.rm = T) \%>\%
  as_tibble()
qv1000 = factor_detector(fvc1000$fvc,
                         st_unidisc(fvc1000$premax,10,'quantile'))[[1]]
qv5000 = factor_detector(fvc5000$fvc,
                         st_unidisc(fvc5000$premax,10,'quantile'))[[1]]
loess_optscale(c(qv1000,qv5000),c(1000,5000))
}
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
