% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gozh.R
\name{gozh_detector}
\alias{gozh_detector}
\title{geographically optimal zones-based heterogeneity detector}
\usage{
gozh_detector(formula, data, cores = 1, type = "factor", alpha = 0.95, ...)
}
\arguments{
\item{formula}{A formula of GOZH detector.}

\item{data}{A data.frame or tibble of observation data.}

\item{cores}{(optional) A positive integer(default is 1). If cores > 1, a 'parallel' package
cluster with that many cores is created and used. You can also supply a cluster object.}

\item{type}{(optional) The type of geographical detector,which must be one of \code{factor}(default),
\code{interaction}, \code{risk}, \code{ecological}.}

\item{alpha}{(optional) Confidence level of the interval,default is \code{0.95}.}

\item{...}{(optional) Other arguments passed to \code{rpart_disc()}.}
}
\value{
A list of tibble with the corresponding result under different detector types.
\describe{
\item{\code{factor}}{the result of factor detector}
\item{\code{interaction}}{the result of interaction detector}
\item{\code{risk}}{the result of risk detector}
\item{\code{ecological}}{the result of ecological detector}
}
}
\description{
Function for geographically optimal zones-based heterogeneity detector.
}
\note{
Only one type of detector is supported in a \code{gozh_detector()} run at a time.
}
\examples{
data('ndvi')
g = gozh_detector(NDVIchange ~ ., data = ndvi)
g

}
\references{
Luo, P., Song, Y., Huang, X., Ma, H., Liu, J., Yao, Y., & Meng, L. (2022). Identifying determinants of
spatio-temporal disparities in soil moisture of the Northern Hemisphere using a geographically optimal
zones-based heterogeneity model. ISPRS Journal of Photogrammetry and Remote Sensing: Official
Publication of the International Society for Photogrammetry and Remote Sensing (ISPRS), 185, 111–128.
https://doi.org/10.1016/j.isprsjprs.2022.01.009
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
