% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font-caching.R
\name{fonts_cache_dir}
\alias{fonts_cache_dir}
\alias{rm_fonts_cache}
\alias{init_fonts_cache}
\title{manage font working directory}
\usage{
fonts_cache_dir()

rm_fonts_cache()

init_fonts_cache()
}
\description{
Initialize or remove font directory used
to store downloaded font files.

This directory is managed by R function \code{\link[=R_user_dir]{R_user_dir()}} but can also
be defined in a non-user location by setting ENV variable \code{GDTOOLS_CACHE_DIR}
or by setting R option \code{GDTOOLS_CACHE_DIR}.

Its value can be read with the \code{fonts_cache_dir()} function.

The directory can be deleted with \code{rm_fonts_cache()} and
created with \code{init_fonts_cache()}.
}
\examples{
fonts_cache_dir()

options(GDTOOLS_CACHE_DIR = tempdir())
fonts_cache_dir()
options(GDTOOLS_CACHE_DIR = NULL)

Sys.setenv(GDTOOLS_CACHE_DIR = tempdir())
fonts_cache_dir()
Sys.setenv(GDTOOLS_CACHE_DIR = "")



init_fonts_cache()
dir.exists(fonts_cache_dir())

rm_fonts_cache()
dir.exists(fonts_cache_dir())
}
\seealso{
Other functions for font management: 
\code{\link{addGFontHtmlDependency}()},
\code{\link{gfontHtmlDependency}()},
\code{\link{install_gfont_script}()},
\code{\link{installed_gfonts}()},
\code{\link{liberationsansHtmlDependency}()},
\code{\link{register_gfont}()},
\code{\link{register_liberationsans}()}
}
\concept{functions for font management}
