\name{simul.simplefield}
\alias{simul.simplefield}
\concept{Simulation}
\concept{ODF visualization}
\concept{Glyph field mapping}
\title{Simulation of a Simple Field of Diffusion Profiles for von Mises-Fisher
 Fibre Orientation Mapping}
\description{
ODF profiles and fibre directions are estimated using mixtures of von Mises-Fisher
 (vMF) distributions for directional mapping. The synthesized field of diffusion
 profiles generated by \code{simul.simplefield} are used to reconstruct
 ODF profiles using GQI or GQI2.
}

\usage{
simul.simplefield(gdi="gqi", b=3000, sigma=NULL,
 threshold=0.5, logplot=TRUE, savedir=tempdir(),
 fmask="m1", ang=NULL)
}

\arguments{
\item{gdi}{ method of ODF reconstruction to use \code{c("gqi", "gqi2")} (default: \code{"gqi"}). }
\item{b}{ strength of the magnetic diffusion gradient (default b-value=3000). }
\item{sigma}{ Rician noise level used in simulation; (default \code{NULL}). }
\item{threshold}{ thresholding generalized fractional anisotropy (GFA) value at each voxel (default: 0.5). }
\item{logplot}{ logical variable for selecting log-scale (default \code{TRUE}). }
\item{savedir}{ directory for saving processed results (default: \code{tempdir()}. }
\item{fmask}{ choice of field mask among a table of pre-defined mask models for simple field simulations. Models are built by indexing array masks. Models \code{c( "m1","m2","m3")} simulate single fiber fields. Models \code{c("mx1","mx2", "mx3"} simulates crossing-fiber fields. }
\item{ang}{ angle in degrees to be cutomize \code{fmask} models (default: \code{NULL} - pre-defined angles are used). }
}

\value{
\code{simul.simplefield} plots the reconstructed field of ODF profiles together with the vMF-estimated fiber directions.
It outputs three data files in NIfTI format named \cr
 \file{data_V1_gqi.nii.gz}, \file{data_V2_gqi.nii.gz}, and
 \file{data_gfa_gqi.nii.gz}.
 The first and second main fibre directions per voxel are contained in \file{data_V1_gqi.nii.gz}, \file{data_V2_gqi.nii.gz}, respectively. The file \file{data_gfa_gqi.nii.gz} contains the GFA metric per voxel.
}

\details{
The number of fibres is automatically estimated from the diffusion profile.
Noisy profiles may be simulated by adding Rician noise to the simulated diffusion profile, with a user defined standard deviation level specified as \eqn{\sigma} (SNR=1/\eqn{\sigma}). 
}

\references{
Ferreira da Silva, A. R. Computational Representation of White Matter Fiber Orientations, \emph{International Journal of Biomedical Imaging}, Vol. 2013, Article ID 232143, Hindawi Publishing Corporation \url{http://dx.doi.org/10.1155/2013/232143}.

Ferreira da Silva, A. R. Facing the Challenge of Estimating Human Brain White Matter Pathways. In \emph{Proc. of the 4th International Joint Conference on Computational Intelligence} (Oct. 2012), K. Madani, J. Kacprzyk, and J. Filipe, Eds., SciTePress, pp. 709-714.

Hornik, K., and Gruen, B. \pkg{movMF}: Mixtures of von Mises-Fisher Distributions, 2012. R package version 0.1-0.

Adler, D., and Murdoch, D. \pkg{rgl}: 3D visualization device system (OpenGL), 2012. R package version 0.92.880.

Barber, C. B., Habel, K., Grasman, R., Gramacy, R. B., Stahel, A., and Sterratt, D. C. \pkg{geometry}: Mesh generation and surface tessellation, 2012. R package version 0.3-2.
} 

\author{ Adelino Ferreira da Silva, Universidade Nova de Lisboa,
  Faculdade de Ciencias e Tecnologia, Portugal, \email{afs at fct.unl.pt}
}

\seealso{
  \code{\link{simulglyph.vmf}},
  \code{\link{simul.fandtasia}},
  \code{\link{synthfiberss2z}},
  \code{\link{plotglyph}},
  \code{\link{gqi.odfvmflines}},
  \code{\link{rgbvolmap}},
  \code{\link{gqi.odfpeaks}},
  \code{\link{gqi.odfpeaklines}},
  \code{\link{gqi.odfvxgrid}}
}

\examples{
\dontrun{
  simul.simplefield(fmask="m1")
  simul.simplefield(gdi="gqi2", fmask="m1")
  ##
  simul.simplefield(logplot=FALSE, fmask="m3")
  simul.simplefield(gdi="gqi2", logplot=FALSE, fmask="m3")
  ##
  simul.simplefield(sigma=0.033, logplot=FALSE, fmask="mx1")
  simul.simplefield(gdi="gqi2", sigma=0.033, logplot=FALSE, fmask="mx1")
}
}

\keyword{ utilities }

