% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{g_measures}
\alias{g_measures}
\alias{g_area}
\alias{g_centroid}
\alias{g_distance}
\alias{g_length}
\alias{g_geodesic_area}
\alias{g_geodesic_length}
\title{Compute measurements for WKB/WKT geometries}
\usage{
g_area(geom, quiet = FALSE)

g_centroid(geom, quiet = FALSE)

g_distance(geom, other_geom, quiet = FALSE)

g_length(geom, quiet = FALSE)

g_geodesic_area(geom, srs, traditional_gis_order = TRUE, quiet = FALSE)

g_geodesic_length(geom, srs, traditional_gis_order = TRUE, quiet = FALSE)
}
\arguments{
\item{geom}{Either a raw vector of WKB or list of raw vectors, or a
character vector containing one or more WKT strings.}

\item{quiet}{Logical value, \code{TRUE} to suppress warnings. Defaults to \code{FALSE}.}

\item{other_geom}{Either a raw vector of WKB or list of raw vectors, or a
character vector containing one or more WKT strings. Must contain the same
number of geometries as \code{geom}, unless \code{geom} contains a single
geometry in which case pairwise distances will be computed for one-to-many
if \code{other_geom} contains multiple geometries (i.e., "this-to-others").}

\item{srs}{Character string specifying the spatial reference system
for \code{geom}. May be in WKT format or any of the formats supported by
\code{\link[=srs_to_wkt]{srs_to_wkt()}}.}

\item{traditional_gis_order}{Logical value, \code{TRUE} to use traditional GIS
order of axis mapping (the default) or \code{FALSE} to use authority compliant
axis order. By default, input \code{geom} vertices are assumed to
be in longitude/latitude order if \code{srs} is a geographic coordinate system.
This can be overridden by setting \code{traditional_gis_order = FALSE}.}
}
\description{
These functions compute measurements for geometries. The input
geometries may be given as a single raw vector of WKB, a list of WKB raw
vectors, or a character vector containing one or more WKT strings.
}
\details{
These functions use the GEOS library via GDAL headers.

\code{g_area()} computes the area for a \code{Polygon} or \code{MultiPolygon}. Undefined
for all other geometry types (returns zero). Returns a numeric vector,
having length equal to the number of input geometries, containing
computed area or '0' if undefined.

\code{g_centroid()} returns a numeric vector of length 2 containing the centroid
(X, Y), or a two-column numeric matrix (X, Y) with number of rows equal to
the number of input geometries.
The GDAL documentation states "This method relates to the SFCOM
\code{ISurface::get_Centroid()} method however the current implementation based
on GEOS can operate on other geometry types such as multipoint, linestring,
geometrycollection such as multipolygons. OGC SF SQL 1.1 defines the
operation for surfaces (polygons). SQL/MM-Part 3 defines the operation for
surfaces and multisurfaces (multipolygons)."

\code{g_distance()} returns the distance between two geometries or \code{-1} if an
error occurs. Returns the shortest distance between the two geometries.
The distance is expressed into the same unit as the coordinates of the
geometries. Returns a numeric vector, having length equal to the number of
input geometry pairs, containing computed distance or '-1' if an error
occurs.

\code{g_length()} computes the length for \code{LineString} or \code{MultiCurve} objects.
Undefined for all other geometry types (returns zero). Returns a numeric
vector, having length equal to the number of input geometries, containing
computed length or '0' if undefined.

\code{g_geodesic_area()} computes geometry area, considered as a surface on the
underlying ellipsoid of the SRS attached to the geometry. The returned area
will always be in square meters, and assumes that polygon edges describe
geodesic lines on the ellipsoid. If the geometry SRS is not a geographic
one, geometries are reprojected to the underlying geographic SRS.
By default, input geometry vertices are assumed to be in longitude/latitude
order if using a geographic coordinate system. This can be overridden with
the \code{traditional_gis_order} argument.
Returns the area in square meters, or \code{NA} in case of error (unsupported
geometry type, no SRS attached, etc.)
Requires GDAL >= 3.9.

\code{g_geodesic_length()} computes the length of the curve, considered as a
geodesic line on the underlying ellipsoid of the SRS attached to the
geometry. The returned length will always be in meters. If the geometry SRS
is not a geographic one, geometries are reprojected to the underlying
geographic SRS.
By default, input geometry vertices are assumed to be in longitude/latitude
order if using a geographic coordinate system. This can be overridden with
the \code{traditional_gis_order} argument.
Returns the length in meters, or \code{NA} in case of error (unsupported geometry
type, no SRS attached, etc.)
Requires GDAL >= 3.10.
}
\note{
For \code{g_distance()}, \code{geom} and \code{other_geom} must be in the same coordinate
reference system. If \code{geom} is a single geometry and \code{other_geom} is a list
or vector of multiple geometries, then distances will be calculated between
\code{geom} and each geometry in \code{other_geom}. Otherwise, no recycling is done
and \code{length(geom)} must equal \code{length(other_geom)} to calculate distance
between each corresponding pair of input geometries.

Geometry validity is not checked. In case you are unsure of the validity
of the input geometries, call \code{g_is_valid()} before, otherwise the result
might be wrong.
}
\examples{
g_area("POLYGON ((0 0, 10 10, 10 0, 0 0))")

g_centroid("POLYGON ((0 0, 10 10, 10 0, 0 0))")

g_distance("POINT (0 0)", "POINT (5 12)")

g_length("LINESTRING (0 0, 3 4)")

f <- system.file("extdata/ynp_fires_1984_2022.gpkg", package = "gdalraster")
lyr <- new(GDALVector, f, "mtbs_perims")

# read all features into a data frame
feat_set <- lyr$fetch(-1)
head(feat_set)

g_area(feat_set$geom) |> head()

g_centroid(feat_set$geom) |> head()

lyr$close()
}
