% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{data_type_helpers}
\alias{data_type_helpers}
\alias{dt_size}
\alias{dt_is_complex}
\alias{dt_is_integer}
\alias{dt_is_floating}
\alias{dt_is_signed}
\alias{dt_union}
\alias{dt_union_with_value}
\alias{dt_find}
\alias{dt_find_for_value}
\title{Helper functions for GDAL raster data types}
\usage{
dt_size(dt, as_bytes = TRUE)

dt_is_complex(dt)

dt_is_integer(dt)

dt_is_floating(dt)

dt_is_signed(dt)

dt_union(dt, dt_other)

dt_union_with_value(dt, value, is_complex = FALSE)

dt_find(bits, is_signed, is_floating, is_complex = FALSE)

dt_find_for_value(value, is_complex = FALSE)
}
\arguments{
\item{dt}{Character string containing a GDAL data type name (e.g.,
\code{"Byte"}, \code{"Int16"}, \code{"UInt16"}, \code{"Int32"}, \code{"UInt32"}, \code{"Float32"},
\code{"Float64"}, etc.)}

\item{as_bytes}{Logical value, \code{TRUE} to return data type size in bytes
(the default), \code{FALSE} to return the size in bits.}

\item{dt_other}{Character string containing a GDAL data type name.}

\item{value}{Numeric value for which to find a data type (passing the real
part if \code{is_complex = TRUE}).}

\item{is_complex}{Logical value, \code{TRUE} if \code{value} is complex (default is
\code{FALSE}), or if complex values are necessary in \code{dt_find()}.}

\item{bits}{Integer value specifying the number of bits necessary.}

\item{is_signed}{Logical value, \code{TRUE} if negative values are necessary.}

\item{is_floating}{Logical value, \code{TRUE} if non-integer values are
necessary.}
}
\description{
These are convenience functions that return information about a raster
data type, return the smallest data type that can fully express two input
data types, or find the smallest data type able to support specified
requirements.
}
\details{
\code{dt_size()} returns the data type size in bytes by default, optionally in
bits (returns zero if \code{dt} is not recognized).

\code{dt_is_complex()} returns \code{TRUE} if the passed type is complex (one of
CInt16, CInt32, CFloat32 or CFloat64), i.e., if it consists of a real and
imaginary component.

\code{dt_is_integer()} returns \code{TRUE} if the passed type is integer (one of
Byte, Int16, UInt16, Int32, UInt32, CInt16, CInt32).

\code{dt_is_floating()} returns \code{TRUE} if the passed type is floating (one of
Float32, Float16, Float64, CFloat16, CFloat32, CFloat64).

\code{dt_is_signed()} returns \code{TRUE} if the passed type is signed.

\code{dt_union()} returns the smallest data type that can fully express both
input data types (returns a data type name as character string).

\code{dt_union_with_value()} unions a data type with the data type found for a
given value, and returns the resulting data type name as character string.

\code{dt_find()} finds the smallest data type able to support the given
requirements (returns a data type name as character string).

\code{dt_find_for_value()} finds the smallest data type able to support the
given \code{value} (returns a data type name as character string).
}
\examples{
elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
ds <- new(GDALRaster, elev_file)

ds$getDataTypeName(band = 1) |> dt_size()
ds$getDataTypeName(band = 1) |> dt_size(as_bytes = FALSE)
ds$getDataTypeName(band = 1) |> dt_is_complex()
ds$getDataTypeName(band = 1) |> dt_is_integer()
ds$getDataTypeName(band = 1) |> dt_is_floating()
ds$getDataTypeName(band = 1) |> dt_is_signed()

ds$close()

f <- system.file("extdata/complex.tif", package="gdalraster")
ds <- new(GDALRaster, f)

ds$getDataTypeName(band = 1) |> dt_size()
ds$getDataTypeName(band = 1) |> dt_size(as_bytes = FALSE)
ds$getDataTypeName(band = 1) |> dt_is_complex()
ds$getDataTypeName(band = 1) |> dt_is_integer()
ds$getDataTypeName(band = 1) |> dt_is_floating()
ds$getDataTypeName(band = 1) |> dt_is_signed()

ds$close()

dt_union("Byte", "Int16")
dt_union_with_value("Byte", -1)
dt_union_with_value("Byte", 256)

dt_find(bits = 32, is_signed = FALSE, is_floating = FALSE)
dt_find_for_value(0)
dt_find_for_value(-1)
dt_find_for_value(NaN)
dt_find_for_value(.Machine$integer.max)
}
\seealso{
\code{\link[=GDALRaster]{GDALRaster$getDataTypeName()}}
}
