test_that("CmbTable works", {
    m <- matrix(c(1,2,3,1,2,3,4,5,6,1,3,2,4,5,6,1,1,1), 6, 3, byrow=TRUE)
    colnames(m) <- c("v1","v2","v3")
    cmb <- new(CmbTable, 3, colnames(m))
    expect_output(show(cmb), "CmbTable")
    cmb$updateFromMatrixByRow(m, 1)
    cmb$update(c(4,5,6), 1)
    cmb$update(c(1,3,5), 1)
    df <- cmb$asDataFrame()
    expect_equal(nrow(df), 5)
    expect_equal(sum(df$count), 8)
    expect_equal(as.matrix(df), cmb$asMatrix())
    expect_equal(sum(cmb$asMatrix()), 62)
})
