% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proj.R
\name{proj_networking}
\alias{proj_networking}
\title{Check, enable or disable PROJ networking capabilities}
\usage{
proj_networking(enabled = NULL)
}
\arguments{
\item{enabled}{Optional logical scalar. Set to \code{TRUE} to enable networking
capabilities or \code{FALSE} to disable.}
}
\value{
Logical \code{TRUE} if PROJ networking capabilities are enabled (as
indicated by the return value of \code{OSRGetPROJEnableNetwork()} in the GDAL
Spatial Reference System C API). Logical \code{NA} is returned if GDAL < 3.4.
}
\description{
\code{proj_networking()} returns the status of PROJ networking capabilities,
optionally enabling or disabling first. Requires GDAL 3.4 or later and
PROJ 7 or later.
}
\examples{
proj_networking()
}
\seealso{
\code{\link[=proj_version]{proj_version()}}, \code{\link[=proj_search_paths]{proj_search_paths()}}

\href{https://github.com/OSGeo/PROJ-data}{PROJ-data on GitHub},
\href{https://cdn.proj.org/}{PROJ Content Delivery Network}
}
