% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdal_rat.R
\name{displayRAT}
\alias{displayRAT}
\title{Display a GDAL Raster Attribute Table}
\usage{
displayRAT(tbl, title = "Raster Attribute Table")
}
\arguments{
\item{tbl}{A data frame formatted as a GDAL RAT (e.g., as returned by
\code{buildRAT()} or \code{GDALRaster$getDefaultRAT()}).}

\item{title}{Character string to be used in the table title.}
}
\value{
An object of class \code{"gt_tbl"} (i.e., a table created with
\code{gt::gt()}).
}
\description{
\code{displayRAT()} generates a presentation table. Colors are shown if the
Raster Attribute Table contains RGB columns.
This function requires package \code{gt}.
}
\examples{
# see examples for `buildRAT()`
}
\seealso{
\code{\link[=buildRAT]{buildRAT()}}, \code{\link[=GDALRaster]{GDALRaster$getDefaultRAT()}}

\code{vignette("raster-attribute-tables")}
}
