% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vsi_read_dir}
\alias{vsi_read_dir}
\title{Read names in a directory}
\usage{
vsi_read_dir(path, max_files = 0L)
}
\arguments{
\item{path}{Character string. The relative or absolute path of a
directory to read.}

\item{max_files}{Integer scalar. The maximum number of files after which to
stop, or 0 for no limit (see Note).}
}
\value{
A character vector containing the names of files and directories
in the directory given by \code{path}. An empty string (\code{""}) is returned if
\code{path} does not exist.
}
\description{
\code{vsi_read_dir()} abstracts access to directory contents. It returns a
character vector containing the names of files and directories in this
directory. This function is a wrapper for \code{VSIReadDirEx()} in the GDAL
Common Portability Library.
}
\note{
If \code{max_files} is set to a positive number, directory listing will stop
after that limit has been reached. Note that to indicate truncation, at
least one element more than the \code{max_files} limit will be returned. If the
length of the returned character vector is lesser or equal to \code{max_files},
then no truncation occurred.
}
\examples{
# regular file system for illustration
data_dir <- system.file("extdata", package="gdalraster")
vsi_read_dir(data_dir)
}
\seealso{
\code{\link[=vsi_mkdir]{vsi_mkdir()}}, \code{\link[=vsi_rmdir]{vsi_rmdir()}}, \code{\link[=vsi_stat]{vsi_stat()}}, \code{\link[=vsi_sync]{vsi_sync()}}
}
