% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{gdalcubes_options}
\alias{gdalcubes_options}
\title{Set or read global options of the gdalcubes package}
\usage{
gdalcubes_options(
  ...,
  threads,
  ncdf_compression_level,
  debug,
  cache,
  ncdf_write_bounds,
  use_overview_images,
  show_progress
)
}
\arguments{
\item{...}{not used}

\item{threads}{number of threads used to process data cubes}

\item{ncdf_compression_level}{integer; compression level for created netCDF files, 0=no compression, 1=fast compression, 9=small compression}

\item{debug}{logical;  print debug messages}

\item{cache}{logical; TRUE if temporary data cubes should be cached to support fast reprocessing of the same cubes}

\item{ncdf_write_bounds}{logical; write dimension bounds as additional variables in netCDF files}

\item{use_overview_images}{logical; if FALSE, all images are read on original resolution and existing overviews will be ignored}

\item{show_progress}{logical; if TRUE, a progress bar will be shown for actual computations}
}
\description{
Set global package options to change the default behavior of gdalcubes. These include how many threads are used to process data cubes, how created netCDF files are compressed, and whether
or not debug messages should be printed.
}
\details{
Data cubes can be processed in parallel where one thread processes one chunk at a time. Setting more threads
than the number of chunks of a cube thus has no effect and will not further reduce computation times.

Caching has no effect on disk or memory consumption, 
it simply tries to reuse existing temporary files where possible.
For example, changing only parameters to \code{plot} will not require
rerunning the full data cube operation chain.

Passing no arguments will return the current options as a list.
}
\examples{
gdalcubes_options(threads=4) # set the number of threads
gdalcubes_options() # print current options
gdalcubes_options(threads=1) # reset
}
