% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearblack.R
\name{nearblack}
\alias{nearblack}
\title{Interface to GDAL's nearblack utility}
\usage{
nearblack(
  infile,
  o = infile,
  ...,
  of,
  co,
  white,
  color,
  near,
  nb,
  setalpha,
  setmask,
  q,
  dryrun = FALSE
)
}
\arguments{
\item{infile}{Character. Path to a GDAL-supported readable
datasource.}

\item{o}{Optionally, a character string giving the path to a
GDAL-supported output file. If not supplied, defaults to
code{infile=}, indicating that the input file should be
modified in place.}

\item{...}{Here, a placeholder argument that forces users to
supply exact names of all subsequent formal arguments.}

\item{of, co, white, color, near, nb, setalpha, setmask, q}{See the GDAL
project's
\href{https://gdal.org/programs/nearblack.html}{nearblack
documentation} for details.}

\item{dryrun}{Logical (default \code{FALSE}). If \code{TRUE},
instead of executing the requested call to GDAL, the function
will print the command-line call that would produce the
equivalent output.}
}
\value{
Silently returns path to \code{datasetname}.
}
\description{
This function provides an interface mirroring that of the GDAL
command-line app \code{nearblack}. For a description of the
utility and the arguments that it takes, see the documentation at
\url{https://gdal.org/programs/nearblack.html}.
}
\examples{
\donttest{
td <- tempdir()
a_rast <- file.path(td, "a.tif")
b_rast <- file.path(td, "b.tif")
file.copy(system.file("extdata/tahoe.tif", package = "gdalUtilities"),
          a_rast)
file.copy(system.file("extdata/tahoe.tif", package = "gdalUtilities"),
          b_rast)
nearblack(a_rast, b_rast, of = "GTiff", near = 150)

## Check that it worked
if(require(rasterVis)) {
    r1 <- raster(a_rast)
    p1 <- levelplot(r1, margin = FALSE, colorkey = FALSE)
    r2 <- raster(b_rast)
    p2 <- levelplot(r2, margin = FALSE, colorkey = FALSE)
    plot(p1, split = c(1, 1, 2, 1))
    plot(p2, split = c(2, 1, 2, 1), newpage = FALSE)
}
}
}
\author{
Joshua O'Brien
}
