% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{makemethod_train_smooth_data}
\alias{makemethod_train_smooth_data}
\title{Create method argument for \code{caret::train} of growth curve smoothers}
\usage{
makemethod_train_smooth_data(sm_method, tuneGrid = NULL)
}
\arguments{
\item{sm_method}{Argument specifying which smoothing method should
be used. Options include "moving-average", "moving-median", 
"loess", "gam", and "smooth.spline".}

\item{tuneGrid}{A data frame with possible tuning value. The columns should 
be named the same as the tuning parameters.

Note that, when using \code{caret::train}, the tuneGrid
must be passed both to this function as well as directly
to \code{caret::train}.}
}
\value{
A list that can be used as the method argument to
        \code{caret::train}. Contains elements:
        \code{library}, \code{type}, \code{prob}, \code{fit},
        \code{parameters}, \code{grid}, \code{fit}, and \code{predict}.
        
        See documentation on using a custom model model in 
        \code{caret::train} for more details.
}
\description{
This function generates a list which is compatible to be used as the
\code{method} argument to \code{caret::train}. This enables users to
call \code{caret::train} directly themselves with \code{smooth_data}
smoothing functions.
}
