% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpval.R
\name{fpval}
\alias{fpval}
\title{ Calculates the regression coefficients, the P-values and the standard P-values for the chosen subset ind}
\usage{
fpval(y,x,ind,q=-1,inr=T,xinr=F)
}
\arguments{
\item{y}{The dependent variable}

\item{x}{The covariates}

\item{ind}{The indices of the subset of the covariates whose P-values are required}

\item{q}{The total number of covariates from which ind was chosen. If q=-1 the number of covariates of x minus length ind plus 1  is taken.}


\item{inr}{Logical If TRUE intercept to be included}

\item{xinr}{If TRUE intercept already included}


}
\value{
apv In order the subset ind, the regression coefficients, the Gaussian P-values, the standard P-values and the proportion of sum of squares explained.

res The residuals
}
\description{
Calculates the regression coefficients, the P-values and the standard P-values for the chosen subset ind.
}
\examples{
data(boston)
a<-fpval(boston[,14],boston[,1:13],c(1,2,4:6,8:13))
}
