% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frpavl.R
\name{frpval}
\alias{frpval}
\title{Robust regression using Huber's psi-function or Hampel's three part redescending psi-function providing P-values}
\usage{
frpval(y,x,ind,cn=1,cnr=c(1,3,5),sg=0,q=-1,scale=T,inr=T,xinr=F,red=F)
}
\arguments{
\item{y}{Dependent variable}

\item{x}{Covariates}

\item{ind}{The subset of covariates for which the results are required}

\item{cn}{Tuning constant for Huber's psi-function}

\item{cnr}{Tuning constants for Hampel's three part redescending psi function}

\item{sg}{Scale. If 0 the MAD is used}

\item{q}{The number of covariates available. If q=-1 the covariates are used.}

\item{scale}{Logical. If TRUE scale sg recalculated}

\item{inr}{Logical, TRUE  to include intercept}

\item{xinr}{Logical TRUE if x already has intercept}

\item{red}{ Logical If TRUE Hampel's three part redescending psi function}
}
\value{
ppi In order the subset ind, the regression coefficients, the Gaussian P-values, the standard P-values

res  Residuals

sg  Scale

rho Sums of rho, psi and psi1 functions.
}
\description{
Robust regression using Huber's psi-function  or Hampel's three part redescending psi-function providing P-values
}
\examples{
data(boston)
a<-frpval(boston[,14],boston[,1:13],1:6)
}
