% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randsignal.R
\name{randsignal}
\alias{randsignal}
\title{Generate random signal with varying regularity.}
\usage{
randsignal(eta, k, A, r)
}
\arguments{
\item{eta}{Smoothness parameter.}

\item{k}{Smoothness parameter.}

\item{A}{Adjacency matrix.}

\item{r}{Optional argument corresponding to the largest eigenvalue of A (in magnitude).}
}
\value{
\code{f} output signal.
}
\description{
Generate \eqn{f = A^k x_{\eta} / r^k}{f = A^k * x_eta / r^k},
with A the adjacency matrix and
\eqn{x_{\eta}} realization of Bernoulli random variables of parameter \eqn{\eta} and \eqn{r} the largest eigenvalue (in magnitude). The generation is carried out in sparse matrices in order to scale up.
}
