% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readwrite_gasanalyzer.R
\name{write_gasexchange}
\alias{write_gasexchange}
\title{Write a gas-exchange tibble to a text file.}
\usage{
write_gasexchange(df, filename, delim = "\\t")
}
\arguments{
\item{df}{a tibble with gas-exchange data}

\item{filename}{path to the output file}

\item{delim}{delimiter to use for the file}
}
\value{
No return value. If there a problems writing the file, a warning or
error will be shown.
}
\description{
The column names and column units are saved as a two-row header. The files
use UTF-16LE and CRLF line headings for compatibility. By default, tabs are
used as delimiter. If you intend to open the file in a spreadsheet program,
it may be helpful to use \code{csv} as file extension.
}
\details{
Note that for data-exchange between R sessions, \code{\link[=saveRDS]{saveRDS()}} and \code{\link[=readRDS]{readRDS()}}
are faster, and support saving and loading list columns (such as calibration
information and equations). This method is primarily meant for exchanging
data with other software packages.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
example <- system.file("extdata//d13C.tsv", package = "gasanalyzer")

# read data and recalculate using default gas-exchange equations:
df <- read_gasexchange(example) |>
  recalculate(create_equations("default"))

# write recaculated data
write_gasexchange(df, "d13C_recalculated.tsv")
\dontshow{setwd(.old_wd)}
}
