% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{\%+\%}
\alias{\%+\%}
\title{Function composition operator}
\usage{
a \%+\% b
}
\arguments{
\item{a}{A function that can be called with one argument.}

\item{b}{A function that can be called with one or more argument,
and result of \code{b()} can be passed to \code{a()}.}
}
\value{
A new function, whose
arguments are what \code{b()} can accept, and whose result is what \code{a()}
can return.
}
\description{
Composite functions \code{a} and \code{b} into \code{a(b(...))}.
}
\examples{
lse <- log\%+\%sum\%+\%exp
lse(1:10)
#logsumexp(1:10)	# actual logsumexp() is more sophistic
log(sum(exp(1:10)))
sum <- sd
lse(1:10)	# lse() is fixed at definition
log(sum(exp(1:10)))
(log\%+\%sum\%+\%exp)(1:10)	# now is (log\%+\%sd\%+\%exp)
}
