% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/garma_main.R
\name{predict.garma_model}
\alias{predict.garma_model}
\title{Predict future values.}
\usage{
\method{predict}{garma_model}(object, n.ahead = 1, ...)
}
\arguments{
\item{object}{(garma_model) The garma_model from which to predict the values.}

\item{n.ahead}{(int) The number of time periods to predict ahead. Default: 1}

\item{...}{Other parameters. Ignored.}
}
\value{
A "ts" object containing the requested forecasts.
}
\description{
Predict ahead using algorithm of (2009) Godet, F
"Linear prediction of long-range dependent time series", ESAIM: PS 13 115-134.
DOI: 10.1051/ps:2008015
}
\examples{
data(AirPassengers)
ap  <- as.numeric(diff(AirPassengers,12))
mdl <- garma(ap,order=c(9,1,0),k=0,method='CSS',include.mean=FALSE)
predict(mdl, n.ahead=12)
}
