% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credentials_app_default.R
\name{credentials_app_default}
\alias{credentials_app_default}
\title{Load Application Default Credentials}
\usage{
credentials_app_default(scopes = NULL, ...)
}
\arguments{
\item{scopes}{A character vector of scopes to request. Pick from those listed
in \href{https://developers.google.com/identity/protocols/googlescopes}{OAuth 2.0 Scopes for Google APIs}.

For certain token flows, the
\code{"https://www.googleapis.com/auth/userinfo.email"} scope is unconditionally
included. This grants permission to retrieve the email address associated
with a token; gargle uses this to index cached OAuth tokens. This grants no
permission to view or send email. It is considered a low value scope and
does not appear on the consent screen.}

\item{...}{Additional arguments passed to all credential functions.}
}
\value{
An \code{\link[httr:Token-class]{httr::TokenServiceAccount}} or an
\code{\link[httr:Token-class]{httr::Token2.0}} or \code{NULL}.
}
\description{
Loads credentials from a file identified via a search strategy known as
Application Default Credentials (ADC). The hope is to make auth "just work"
for someone working on Google-provided infrastructure or who has used Google
tooling to get started. A sequence of paths is consulted, which we describe
here, with some abuse of notation. ALL_CAPS represents the value of an
environment variable and \code{\%||\%} is used in the spirit of a \href{https://en.wikipedia.org/wiki/Null_coalescing_operator}{null coalescing operator}.\preformatted{GOOGLE_APPLICATION_CREDENTIALS
CLOUDSDK_CONFIG/application_default_credentials.json
# on Windows:
(APPDATA \%||\% SystemDrive \%||\% C:)\gcloud\application_default_credentials.json
# on not-Windows:
~/.config/gcloud/application_default_credentials.json
}

If the above search successfully identifies a JSON file, it is parsed and
ingested either as a service account token or a user OAuth2 credential.
}
\examples{
\dontrun{
credentials_app_default()
}
}
\seealso{
\url{https://cloud.google.com/docs/authentication/production#providing_credentials_to_your_application}

\url{https://cloud.google.com/sdk/docs/}

Other credential functions: \code{\link{credentials_gce}},
  \code{\link{credentials_service_account}},
  \code{\link{credentials_user_oauth2}},
  \code{\link{token_fetch}}
}
\concept{credential functions}
