% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Var-list-generics.R, R/Var-list-methods.R
\docType{methods}
\name{SortBy}
\alias{SortBy}
\alias{SortBy<-}
\alias{SortBy,.varList-method}
\alias{SortBy,NULL-method}
\alias{SortBy,character-method}
\alias{SortBy,.query-method}
\alias{SortBy<-,.query-method}
\title{SortBy.}
\usage{
SortBy(object, ..., desc = logical(0), type = c("VALUE", "DELTA",
  "SMART", "HISTOGRAM_BUCKET", "DIMENSION_AS_INTEGER")[0L])

SortBy(object) <- value

\S4method{SortBy}{.varList}(object, desc, type)

\S4method{SortBy}{`NULL`}(object)

\S4method{SortBy}{character}(object, ..., desc = logical(0),
  type = c("VALUE", "DELTA", "SMART", "HISTOGRAM_BUCKET",
  "DIMENSION_AS_INTEGER")[0L])

\S4method{SortBy}{.query}(object, value)

\S4method{SortBy}{.query}(object) <- value
}
\arguments{
\item{object}{A character vector or list of dimensions or metrics to sort by.
If character, then prefixing the dimension name with a "+" means ascending
order or "-" for descending order. By default metrics are sorted in
descending order, while dimensions are by default in ascending order.
Alternatively, supply a query object and replacement dimensions and metrics
or sort by.}

\item{...}{further dimensions or metrics to sort by, or if \code{object} is a
query then the replacement list of dimensions or metrics to sort by.}

\item{desc}{A logical vector, same length as the resulting list of dimension
or metric variables, indicating which columns of the resulting query
response should be sorted in descending order.}

\item{type}{A character vector, same length as the vector of variables to sort by,
indicating the method of sorting to be applied to each variable. Available sort
types are "VALUE", "DELTA", "SMART", "HISTOGRAM_BUCKET" or "DIMENSION_AS_INTEGER".}

\item{value}{The replacement dimensions and metrics for the supplied object.}
}
\description{
Get the sortBy order of the query.

Set the order of rows returned by Google Analytics.
}
\section{Methods (by class)}{
\itemize{
\item \code{.varList}: Coerce a .varList object to a .sortBy child-class.

\item \code{NULL}: Returns NULL

\item \code{character}: Return a sortBy object given by the variables named within
a character vector, optionally denoted with - or + to indicate descending or
ascending sorting for each variable respectively in order of precedence.

\item \code{.query}: Replace the sort by argument of a query.

\item \code{.query}: Replace the sort by argument of a query.
}}

