% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gdKNearestNeighbors}
\alias{gdKNearestNeighbors}
\title{Search for k nearest neighbors}
\usage{
gdKNearestNeighbors(dataRecord, k = 1L, useSearchTree = FALSE)
}
\arguments{
\item{dataRecord}{List containing a data record}

\item{k}{Number of nearest neighbors}

\item{useSearchTree}{Boolean value indicating if a search tree should be used.}
}
\value{
A list of rows in generative data
}
\description{
Search for k nearest neighbors in generative data for a data record.
When the data record contains NA values only the non-NA values are considered in search.
By default a linear search is performed. When a search tree is used search is performed on a tree
which is built once in the first function call.
Building a tree is also triggered when NA values in data records change in subsequent function calls.
}
\examples{
\dontrun{
gdRead("gd.bin")
gdKNearestNeighbors(list(5.1, 3.5, 1.4, 0.2), 3)}
}
