% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_gambin.R
\name{fit_abundances}
\alias{fit_abundances}
\alias{fitGambin}
\title{Fit a unimodal or multimodal gambin model to a species abundance distribution}
\usage{
fit_abundances(abundances, subsample = 0, no_of_components = 1, cores = 1)

fitGambin(abundances, subsample = 0)
}
\arguments{
\item{abundances}{Either a vector of abundances of all species in the sample/community; or the result of \code{create_octaves}}

\item{subsample}{The number of individuals to sample from the community before fitting the GamBin model.
If subsample == 0 the entire community is used}

\item{no_of_components}{Number of components (i.e. modes) to fit.The default (no_of_components == 1) fits the standard
unimodal gambin model.}

\item{cores}{No of cores to use when fitting. Use \code{parallel::detectCores()} to
detect the number of cores on your machine.}
}
\value{
The \code{fit_abundances} function returns an object of class \code{gambin}, with the \code{alpha},
\code{w}
and \code{MaxOctave} parameters of the gambin mixture distribution,
the likelihood of the fit, and the empirical distribution over octaves.
}
\description{
Uses maximum likelihood methods to fit the GamBin model (with a given number of modes) to binned
species abundances. To control for the effect of sample size, the abundances
may be subsampled prior to fitting.
}
\details{
The gambin distribution is fit to the number of species in abundance octaves,
as specified by the \code{create_octaves} function. Because the shape of species abundance
distributions depend on sample size, abundances of different communities should be compared
on equally large samples. The sample size can be set by the \code{subsample} parameter.
To estimate \code{alpha} from a standardised sample, the function must be run several
times; see the examples. The \code{no_of_components} parameter enables multimodal gambin
distributions to be fitted. For example, setting \code{no_of_components} equal to 2, the bimodal
gambin model is fitted. When a multimodal gambin model is fitted (with g modes), the return values are the alpha
parameters of the g different component distributions, the max octave values for the g component distributions 
(as the max octave values for the g-1 component distributions are allowed to vary), and the and the weight parameter(s) 
which denote the fraction of objects within each g component distribution. When fitting multimodal gambin models
(particularly on large datasets), the optimisation algorithm can be slow. In such cases, the process
can be speeded up by using the \code{cores} parameter to enable parallel computing.

The \code{plot} method creates a barplot showing the observed number of
species in octaves, with the fitted GamBin distribution shown as black dots.
The \code{summary.gambin} method provides additional useful information such
as confidence intervals around the model parameter estimates.
}
\examples{
data(moths)
fit = fit_abundances(moths)
barplot(fit)
lines(fit, col=2)
summary(fit)
# gambin parameters based on a standardized sample size of 1000 individuals
stand_fit <- replicate(20, fit_abundances(moths, 1000)$alpha) #may take a while on slower computers
print(c(mean = mean(stand_fit), sd = sd(stand_fit)))
# a bimodal gambin model
biMod <- fit_abundances(moths, no_of_components = 2)
}
