% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deconstruct_gambin.R
\name{deconstruct_modes}
\alias{deconstruct_modes}
\title{Deconstruct a multimodal gambin model fit}
\usage{
deconstruct_modes(fit, dat, peak_val = NULL, abundances = "abundances",
  species = "species", categ = NULL, plot_modes = TRUE,
  col.statu = NULL)
}
\arguments{
\item{fit}{A gambin model fit where the number of components is greater than
one (see \code{\link{fit_abundances}}).}

\item{dat}{A matrix or dataframe with at least two columns, including the
abundance data used to fit the multimodal gambin model and the species
names. An optional third column can be provided that contains species
classification data.}

\item{peak_val}{A vector of of modal octave values. If \code{peak_val =
NULL}, the modal octave values are taken from the model fit object.}

\item{abundances}{The name of the column in \code{dat} that contains the
abundance data (default = "abundance").}

\item{species}{The name of the column in \code{dat} that contains the species
names (default = "species").}

\item{categ}{Either NULL if no species classification data are provided, or
the name of the column in \code{dat} that contains the species
classification data.}

\item{plot_modes}{A logical argument specifying whether a barplot of the
model fit with highlighted octaves should be generated. If \code{categ =
FALSE} a barplot is produced whereby just the modal octaves are highlighted
in red. If \code{categ = TRUE} a barplot is produced whereby the bar for
each octave is split into n parts, where n equals the number of species
categories.}

\item{col.statu}{A vector of colours (of length n) for the split barplot,
where n equals the number of species categories.}
}
\value{
An object of class \code{deconstruct}. The object
  is a list with either two or three elements. If \code{categ = NULL}, the
  list has two elements: 1) 'Peak_locations', which contains the modal octave
  values, and 2) 'Species_per_octave', which is a list where each element
  contains the species names in an octave. If \code{categ != NULL}, the
  returned object has a third element: 3) 'Summary_table', which contains a
  dataframe (frequency table) with the numbers of each category of species in
  each octave.
}
\description{
Deconstruct a multimodal gambin model fit by locating the modal
  octaves and (if species classification data are provided) determining the
  proportion of different types of species in each octave.
}
\details{
The function enables greater exploration of a multimodal gambin
  model fit. If no species classification data are available (i.e.
  \code{categ = NULL}) the function returns the modal octaves of the
  n-component distributions and the names of the species located in each
  octave. If \code{plot_modes = TRUE} a plot is returned with the modal
  octaves highlighted in red. If species classification data are provided the
  function also returns a summary table with the number of each species
  category in each octave provided. The user can then use these data to run
  different tests to test whether, for example, the number of species in each
  category in the modal octaves is significantly different than expected by
  chance. If \code{plot_modes = TRUE} a split barplot is returned whereby
  each bar (representing an octave) is split into the n species categories.

  Species classification data should be of type character (e.g. native or
  invasive).

  Occasionally, some of the component distributions in a multimodal gambin
  model fit have the same modal octave; this is more common when fitting the
  3-component model. When this occurs a warning is produced, but it is not a
  substantive issue.
}
\examples{
data(categ)
fits2 = fit_abundances(categ$abundances, no_of_components = 2)
#without species classification data
deconstruct_modes(fits2, dat = categ, peak_val = NULL, abundances = "abundances", 
species = "species", categ = NULL, plot_modes = TRUE)
#with species classification data
deconstruct_modes(fits2, dat = categ, categ = "status", col.statu = c("green", "red", "blue"))
#manually choose modal octaves
deconstruct_modes(fits2, dat = categ, peak_val = c(0,1))
}
\author{
Thomas J. Matthews & Francois Rigal
}
