% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_values.R
\name{show_values}
\alias{show_values}
\alias{search_values}
\title{Show or search for values within a specified field}
\usage{
show_values(df)

search_values(df, query)
}
\arguments{
\item{df}{A search result from \code{\link[=search_fields]{search_fields()}}, \code{\link[=search_profiles]{search_profiles()}} or
\code{\link[=search_lists]{search_lists()}}.}

\item{query}{A string specifying a search term. Not case sensitive.}
}
\value{
A \code{tibble} of values for a specified field, profile or list.
}
\description{
Users may wish to see the specific values \emph{within} a chosen field, profile
or list to narrow queries or understand more about the information of
interest. \code{show_values()} provides users with these values. \code{search_values()}
allows users for search for specific values within a specified field.
}
\details{
Each \strong{Field} contains categorical or numeric values.
For example:
\itemize{
\item The \code{field} "year" contains values 2021, 2020, 2019, etc.
\item The \code{field} "stateProvince" contains values New South Wales, Victoria, Queensland, etc.
These are used to narrow queries with
\code{\link[=filter.data_request]{filter()}} or \code{\link[=galah_filter]{galah_filter()}}.
}

Each \strong{Profile} consists of many individual quality filters.
For example, the "ALA" profile consists of values:
\itemize{
\item Exclude all records where spatial validity is FALSE
\item Exclude all records with a latitude value of zero
\item Exclude all records with a longitude value of zero
}

Each \strong{List} contains a list of species, usually by taxonomic name.
For example, the Endangered Plant species list contains values:
\itemize{
\item Acacia curranii (Curly-bark Wattle)
\item Brachyscome papillosa (Mossgiel Daisy)
\item Solanum karsense (Menindee Nightshade)
}
}
\examples{
\dontrun{
# Show values in field 'cl22'
search_fields("cl22") |> 
  show_values()

# This is synonymous with `request_metadata() |> unnest()`.
# For example, the previous example can be run using:
request_metadata() |>
  filter(field == "cl22") |>
  unnest() |>
  collect() 

# Search for any values in field 'cl22' that match 'tas'
search_fields("cl22") |> 
  search_values("tas")

# See items within species list "dr19257"
search_lists("dr19257") |> 
  show_values()
}
}
