% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse.R
\name{collapse.data_request}
\alias{collapse.data_request}
\alias{collapse.metadata_request}
\alias{collapse.files_request}
\title{Generate a query}
\usage{
\method{collapse}{data_request}(x, ..., mint_doi, .expand = FALSE)

\method{collapse}{metadata_request}(x, .expand = FALSE, ...)

\method{collapse}{files_request}(x, thumbnail = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{data_request}, \code{metadata_request} or
\code{files_request}}

\item{...}{Arguments passed on to other methods}

\item{mint_doi}{Logical: should a DOI be minted for this download? Only
applies to \code{type = "occurrences"} when atlas chosen is "ALA".}

\item{.expand}{Logical: should the \code{query_set} be returned? This object
shows all the requisite data needed to process the supplied query. Defaults
to \code{FALSE}; if \code{TRUE} will append the \code{query_set} to an extra slot in the
\code{query} object.}

\item{thumbnail}{Logical: should thumbnail-size images be returned? Defaults
to \code{FALSE}, indicating full-size images are required.}
}
\value{
An object of class \code{query}, which is a list-like object containing at
least the slots \code{type} and \code{url}.
}
\description{
\code{collapse()} constructs a valid query so it can be
inspected before being sent. It typically occurs at the end of a pipe,
traditionally begun with \code{galah_call()}, that is used to define a query.
As of version 2.0, objects of class \code{data_request} (created using
\code{request_data()}), \code{metadata_request} (from \code{request_metadata()}) or
\code{files_request} (from \code{request_files()}) are all supported by \code{collapse()}.
Any of these objects can be created using \code{galah_call()} via the \code{method}
argument.
}
