% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_identify.R
\name{galah_identify}
\alias{galah_identify}
\title{Narrow a query by passing taxonomic identifiers}
\usage{
galah_identify(..., search = TRUE)
}
\arguments{
\item{...}{one or more scientific names (if \code{search = TRUE}) or taxonomic
identifiers (if \code{search = FALSE}); or an object of class \code{ala_id} (from
\code{search_taxa}).}

\item{search}{(logical); should the results in question be passed to
\code{search_taxa}?}
}
\value{
A tibble containing identified taxa.
}
\description{
When conducting a search or creating a data query, it is common to identify
a known taxon or group of taxa to narrow down the records or results returned.
}
\details{
\code{galah_identify()} is used to identify taxa you want returned in a search or
a data query. Users to pass scientific names or taxonomic identifiers
with pipes to provide data only for the biological group of interest.

It is good to use \code{\link[=search_taxa]{search_taxa()}} and \code{\link[=search_identifiers]{search_identifiers()}}
first to check that the taxa you provide to \code{galah_identify()} return the
correct results.
}
\examples{
\dontrun{
# Specify a taxon. A valid taxon will return an identifier.
galah_identify("reptilia")

# Specify more than one taxon at a time.
galah_identify("reptilia", "mammalia", "aves", "pisces")

# Use `galah_identify()` to narrow your queries
galah_call() |> 
  galah_identify("Eolophus") |>
  atlas_counts()

# If you know a valid taxon identifier, add it and set `search = FALSE`.
galah_call() |> 
  galah_identify("https://biodiversity.org.au/afd/taxa/009169a9-a916-40ee-866c-669ae0a21c5c", 
                 search = FALSE) |>
  atlas_counts()
}

}
\seealso{
\code{\link[=search_taxa]{search_taxa()}} to find identifiers from scientific names;
\code{\link[=search_identifiers]{search_identifiers()}} for how to get names if taxonomic identifiers
are already known.
}
