% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_geolocate.R
\name{galah_geolocate}
\alias{galah_geolocate}
\title{Narrow a query using a WKT string}
\usage{
galah_geolocate(...)
}
\arguments{
\item{...}{a single wkt string or sf object}
}
\value{
length-1 object of class \code{character} and \code{atlas_locations},
containing a WKT string representing the area provided.
}
\description{
Restrict results to those from a specified area. Areas must be polygons
and be specified as either an sf object, or a 'well-known text' (wkt) string.
}
\details{
WKT strings longer than 10000 characters will not be
accepted by the ALA- so the sf object or WKT string may need to be
simplified.
}
\section{Examples}{


Search for records using a shapefile\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_config(email = "your-email@email.com")

location <- galah_geolocate(st_read(path/to/shapefile))
atlas_occurrences(geolocate = location)
}\if{html}{\out{</div>}}

Search for records using a Well-known Text geometry (WKT)\if{html}{\out{<div class="sourceCode r">}}\preformatted{wkt <- "POLYGON((142.36228 -29.00703,142.74131 -29.00703,142.74131 -29.39064,142.36228 -29.39064,142.36228 -29.00703))"

atlas_counts(geolocate = galah_geolocate(wkt))
#> # A tibble: 1 x 1
#>   count
#>   <int>
#> 1  3300
}\if{html}{\out{</div>}}
}

\seealso{
\code{\link[=search_taxa]{search_taxa()}}, \code{\link[=galah_filter]{galah_filter()}} and
\code{\link[=galah_select]{galah_select()}} for other ways to restrict the information
returned by \code{\link[=atlas_occurrences]{atlas_occurrences()}} and related functions.
}
