% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_taxa.R
\name{select_taxa}
\alias{select_taxa}
\title{Taxon information}
\usage{
select_taxa(
  query,
  is_id = FALSE,
  children = FALSE,
  counts = FALSE,
  all_ranks = FALSE
)
}
\arguments{
\item{query}{\code{string}: A vector containing one or more search terms,
given as strings. Search terms can be scientific or common names, or
taxonomic identifiers. If greater control is required to disambiguate search
terms, taxonomic levels can be provided explicitly via a named \code{list}
for a single name, or a \code{data.frame} for multiple names (see examples).
Note that searches are not case-sensitive.}

\item{is_id}{\code{logical}: Is the query a unique identifier? Defaults to 
\code{FALSE}, meaning that queries are assumed to be taxonomic names.}

\item{children}{\code{logical}: Return child concepts for the provided
query? DEPRECATED: use \code{\link{ala_taxonomy}} instead.}

\item{counts}{\code{logical}: return occurrence counts for all
taxa found? \code{FALSE} by default. 
DEPRECATED: use \code{\link{ala_counts}} instead.}

\item{all_ranks}{\code{logical}: Include all available
intermediate ranks for taxa? e.g. suborder, superfamily. Retrieving this
information requires an additional web service call so will slow down the
query. DEPRECATED: use \code{\link{ala_taxonomy}} instead.}
}
\value{
An object of class \code{data.frame} and \code{ala_id}
containing taxonomic information.
}
\description{
In the ALA, all records are associated with an identifier that uniquely
identifies the taxon to which that record belongs. However, taxonomic names
are often ambiguous due to homonymy; i.e. re-use of names (common or
scientific) in different clades. Hence, \code{select_taxa} provides a means
to search for taxonomic names and check the results are 'correct' before
proceeded to download data via \code{\link{ala_occurrences}()},
\code{\link{ala_species}()} or \code{\link{ala_counts}()}. The resulting
\code{data.frame} of taxonomic information can be passed directly to
\code{ala_} functions to filter records to the specified taxon or taxa.
}
\examples{
\dontrun{
# Search using a single term
select_taxa("Reptilia")
# or equivalently:
select_taxa("reptilia") # not case sensitive

# Search using an unique taxon identifier
select_taxa(query = "https://id.biodiversity.org.au/node/apni/2914510")

# Search multiple taxa
select_taxa(c("reptilia", "mammalia")) # returns one row per taxon
}
}
\seealso{
\code{\link{select_columns}}, \code{\link{select_filters}} and
\code{\link{select_locations}} for other ways to restrict the information returned
by \code{\link{ala_occurrences}} and related functions.
\code{\link{ala_taxonomy}} to look up taxonomic trees.
}
