% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_filters.R
\name{select_filters}
\alias{select_filters}
\title{Select filters to narrow down occurrence queries}
\usage{
select_filters(..., profile = NULL)
}
\arguments{
\item{...}{filters, in the form \code{field = value}}

\item{profile}{\code{string}: (optional) a data quality profile to apply to the
records. See \code{\link{find_profiles}} for valid profiles. By default
no profile is applied.}
}
\value{
A \code{data.frame} of filter values.
}
\description{
'filters' are arguments of the form \code{field = value} that are used
to narrow down the number of records returned by a specific query.
For example, it is common for users to request records from a particular year
(\code{year = 2020}), or records that are associated with a physical
specimen (\code{basisOfRecord = "PreservedSpecimen"}).
The result of \code{select_filters} can be passed to the \code{filters}
argument in \code{\link{ala_occurrences}()}, \code{\link{ala_species}()} or
\code{\link{ala_counts}()}.
}
\details{
By default filters are included, but they can be excluded by wrapping the
filter values in \code{\link{exclude}} (see below for examples).
}
\examples{
\dontrun{
# Create a custom filter for records of interest
filters <- select_filters(
    basisOfRecord = "HumanObservation",
    year = 2020,
    stateProvince = "New South Wales")

# Add the default ALA data quality profile
filters <- select_filters(
    basisOfRecord = "HumanObservation",
    year = 2020,
    stateProvince = "New South Wales",
    profile = "ALA")
    
# Use filters to exclude particular values
filters <- select_filters(year = exclude(seq(2011,2021)))
}
}
\seealso{
\code{\link{select_taxa}}, \code{\link{select_columns}} and
\code{\link{select_locations}} for other ways to restrict the information returned
by \code{\link{ala_occurrences}} and related functions. Use
\code{\link{search_fields}} to find fields that
you can filter by, and \code{\link{find_field_values}} to find what values
of those filters are available.
\code{\link{exclude}} for excluding a filter value.
}
